<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\InvestmentController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\User\UserInvestmentController;


Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::group([
    'middleware' => ['auth', 'role:admin'],
    'as' => 'admin.',
    'prefix' => 'admin',

], function () {
    //USERS CRUD ROUTE
    Route::get('/users', [UserController::class, 'showUsers'])->name('show_users');
    Route::get('/users/delete/{user}', [UserController::class, 'deleteUser'])->name('delete_user');

    //ADMIN CRUD ROUTE
    Route::get('/admins', [UserController::class, 'showAdmins'])->name('show_admins');
   
    //INVESTMENT CRUD ROUTE
    Route::get('/investments', [InvestmentController::class, 'showInvestments'])->name('show_investments');
    Route::post('/crypto-investments', [InvestmentController::class, 'createInvestments'])->name('create_investments');
    Route::get('/crypto-investments/delete/{id}',[InvestmentController::class, 'destroyInvestments'])->name('delete_investments');

});



Route::group([
    'middleware' => ['auth', 'role:user'],
    'as' => 'user.',
    'prefix' => 'user',

], function () {


   
    //INVESTMENT 
    Route::get('/investments', [UserInvestmentController::class, 'showInvestments'])->name('show_investments');
    Route::get('/investments_details', [UserInvestmentController::class, 'showInvestmentsDetails'])->name('show_investmentsdetails');



});

