
@extends('layouts.dashboard')

@section('content')
    <!-- content @s -->
    <div class="nk-content ">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="nk-block">
                        <div class="row g-gs">
                            <div class="nk-content-body">
                                <ul class="row g-gs preview-icon-svg">
                                    @forelse($investments as $investment)
                                        <li class="col-lg-6  col-md-6 col-sm-1">
                                            <div class="preview-icon-box card">
                                                <a href="#">
                                                    <div class="preview-icon-wrap">
                                                        <img
                                                            src="{{Storage::url($investment->setting_file_path)}}"
                                                            width="80" height="80">
                                                    </div>
                                                    <span class="preview-icon-name"><b>{{$investment->name}}</b></span>
                                                </a>

                                                <h5> Starting From ${{$investment->minimum_amount}} to ${{$investment->maximum_amount}}</h5>
                                                 <p>{{$investment->description}}</p>
                                                <a href="{{route('user.show_investmentsdetails')}}" class="btn btn-primary center">Invest Now</a>
                                            </div>
                                        </li><!-- .col -->
                                    @empty
                                        <div class="position-absolute top-50 start-50 translate-middle">
                                            No Investment Packages Available
                                        </div>
                                    @endforelse
                                </ul>
                            </div>
                        </div><!-- .row -->
                    </div><!-- .nk-block -->
                </div>
            </div>
        </div>
    </div>
    <!-- content @e -->
@endsection



