@if($paginator->hasPages())
    <div class="nk-block-between-md g-3">
        <div class="g">
            <ul class="pagination justify-content-center justify-content-md-start">
                @if($paginator->onFirstPage())
                    <li class="page-item disabled"><a class="page-link" href="#">Prev</a></li>
                @else
                    <li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}">Prev</a></li>
                @endif


                @foreach ($elements as $element)

                    @if (is_string($element))
                        <li class="page-item"><a class="page-link" href="#">{{$element}}</a></li>
                    @endif

                    @if (is_array($element))
                        @foreach ($element as $page => $url)
                            @if ($page == $paginator->currentPage())
                                <li class="page-item active"><a class="page-link" href="{{$url}}">{{$page}}</a></li>
                            @else
                                <li class="page-item"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                            @endif
                        @endforeach
                    @endif
                @endforeach


                @if($paginator->hasMorePages())
                    <li class="page-item"><a class="page-link" href="{{ $paginator->nextPageUrl() }}">Next</a></li>
                @else
                    <li class="page-item disabled"><a class="page-link" href="#">Next</a></li>
                @endif
            </ul><!-- .pagination -->
        </div>
    </div><!-- .nk-block-between -->
@endif
