<?php

namespace Database\Seeders;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Permission::create(['name' => 'create-user']);
        Permission::create(['name' => 'edit-user']);
        Permission::create(['name' => 'delete-user']);
        Permission::create(['name' => 'view-user']);

        $permission = Permission::all();
        $role1 = Role::create(['name' => 'admin']);
        $role1->givePermissionTo($permission);
        $user = User::create([
            'name' => 'Ogundele Festus',
            'email' => 'admin@gmail.com',
            'phone_number' => '09069127288',
            'password' => bcrypt('Fessy$$$1'),
            'email_verified_at' => Carbon::now(),
        ]);
        $user->assignRole($role1);

        $role2 = Role::create(['name' => 'user']);
        $role2->givePermissionTo($permission);
        $user = User::create([
            'name' => 'Adekunle Remi',
            'email' => 'user@gmail.com',
            'phone_number' => '09069127280',
            'password' => bcrypt('Fessy$$$1'),
            'email_verified_at' => Carbon::now(),
        ]);
        $user->assignRole($role2);

    }
}
