<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investments', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->string('name'); // Investment name
            $table->decimal('minimum_amount', 15, 2); // Minimum investment amount
            $table->decimal('maximum_amount', 15, 2); // Maximum investment amount
            $table->decimal('interest', 5, 2); // Interest rate (e.g., 5.75%)
            $table->string('setting_file_path'); // Path to uploaded settings file
            $table->text('description')->nullable(); // Optional description
            $table->softDeletes();
            $table->timestamps(); // Created_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investments');
    }
};
