<?php

use Illuminate\Support\Carbon;

//DB TIME TO HUMAN READABLE TIME HELPER




if (! function_exists('db_to_human_time')) {
    function db_to_human_time($time): string
    {
        $dt = Carbon::createFromFormat('Y-m-d H:i:s', $time);

        return $dt->diffForHumans();
    }
}

if (! function_exists('user_initials')) {
    function user_initials(string $name): string
    {
        $name = explode(' ', $name);

        return strtoupper(substr($name[0], 0, 1).substr($name[0], 1, 0));
    }
}
