<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        $users = User::role('user')->get();
        $usersCount = User::role('user')->count();
        $adminsCount = User::role('admin')->count();

        return view('home', compact('users','usersCount','adminsCount'));
    }
}
