<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Foundation\Application;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'verified']);
    }

    public function showUsers(): View|Application|Factory|\Illuminate\Contracts\Foundation\Application
    {
        return view('admin.users', [
            'users' => User::role('user')->paginate(10),
        ]);
    }

    public function deleteUser(User $user): RedirectResponse
    {
        if (! $user->delete()) {
            return back()->with('error', 'User not Deleted');
        }

        return back()->with('success', 'User Deleted!');
    }

    public function showAdmins(): View|Application|Factory|\Illuminate\Contracts\Foundation\Application
    {
        return view('admin.admins', [
            'users' => User::role('admin')->paginate(10),
        ]);
    }

    public function makeAdmin(Request $request): RedirectResponse
    {
        $validatedData = $request->validate([
            'email' => 'required|email',
        ]);

        try {
            $user = User::where('email', $request->post('email'))->first();

            if (is_null($user)) {
                return back()->with('error', 'User Not Found!');
            }

            if (! $user->hasRole('user')) {
                return back()->with('error', 'User is already an admin!');
            }

            $user->syncRoles('admin');

            return back()->with('success', 'Admin Created!');
        } catch (\Exception $e) {
            return back()->with('error', 'Error! Try Again');
        }
    }

    public function removeAdmin(User $user): RedirectResponse
    {
        try {
            if (! $user->hasRole('admin')) {
                return back()->with('error', 'User is not an admin!');
            }

            $user->syncRoles('user');

            return back()->with('success', 'Admin Removed!');
        } catch (\Exception $e) {
            return back()->with('error', 'Error! Try Again');
        }
    }

    

    
   
}
